﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using ModbusTCP;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;

namespace module_tester2
{
    enum ENUM_CONSOLE_CODES
    {
        OPERATION_NONE = 0,
        TEST_EEPROM,
        TEST_FLASH,
        TEST_RS485,
        TEST_ETHERNET,
        TEST_OLED,
        TEST_7SEG,
        WRITE_SN,
        READ_SN,
        ERASE_SN,
        WRITE_MAC,
        READ_MAC,
        ERASE_MAC
    }


    public partial class Form1 : Form
    {
        private ModbusTCP.Master MBmaster;

        private bool console_port_is_open = false;
        private byte[] console_rx_buffer;
        private byte[] rs485_buffer;
        private int rs485_pos = 0;


        private int rx_pos = 0;
        private ENUM_CONSOLE_CODES console_operation =  ENUM_CONSOLE_CODES.OPERATION_NONE;

        public Form1()
        {
            InitializeComponent();

            console_rx_buffer = new byte[ 128 ];
            rs485_buffer = new byte[128];
        }

        private void view_console_data(string prefix, string data)
        {
            string str = prefix + " " + data;

            ConsoleListBox.Items.Add(str);
            ConsoleListBox.SelectedIndex = ConsoleListBox.Items.Count - 1;
        }

        private void parse_console_data( string data )
        {
            if( data.Contains("SUCCESS") )
            {
                switch(console_operation )
                {
                    case ENUM_CONSOLE_CODES.TEST_EEPROM:
                        label_eeprom_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_eeprom_test_status.ForeColor = Color.Green;
                        break;

                    case ENUM_CONSOLE_CODES.TEST_FLASH:
                        label_flash_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_flash_test_status.ForeColor = Color.Green;
                        break;

                    case ENUM_CONSOLE_CODES.TEST_RS485:
                        label_rs_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_rs_test_status.ForeColor = Color.Green;
                        serialPortRS485.Close();
                        RS485PortTimer.Stop();
                        break;
                    case ENUM_CONSOLE_CODES.TEST_ETHERNET:
                        label_ethernet_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_ethernet_test_status.ForeColor = Color.Green;
                        break;
                    case ENUM_CONSOLE_CODES.TEST_OLED:
                        label_olerd_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_olerd_test_status.ForeColor = Color.Green;
                        break;
                    case ENUM_CONSOLE_CODES.TEST_7SEG:
                        label_seg7_test_status.Text = "ТЕСТ ПРОЙДЕН УСПЕШНО";
                        label_seg7_test_status.ForeColor = Color.Green;
                        break;

                    case ENUM_CONSOLE_CODES.WRITE_SN:
                        label_sn_status.Text = "ЗН успешно записан";
                        label_sn_status.ForeColor = Color.Green;
                        break;
                    case ENUM_CONSOLE_CODES.READ_SN:
                        label_sn_status.Text = "ЗН успешно прочитан";
                        label_sn_status.ForeColor = Color.Green;
                        string sn_str = data.Substring(3, 12);
                        SNtextBox.Text = sn_str;
                        break;

                    case ENUM_CONSOLE_CODES.ERASE_SN:
                        label_sn_status.Text = "ЗН успешно стерт";
                        label_sn_status.ForeColor = Color.Green;
                        break;
                    case ENUM_CONSOLE_CODES.WRITE_MAC:
                        label_mac_status.Text = "MAC успешно записан";
                        label_mac_status.ForeColor = Color.Green;
                        break;
                    case ENUM_CONSOLE_CODES.READ_MAC:
                        label_mac_status.Text = "MAC успешно прочитан";
                        label_mac_status.ForeColor = Color.Green;
                        string mac_str = data.Substring(4, 17);
                        MACtextBox.Text = mac_str;
                        break;
                    case ENUM_CONSOLE_CODES.ERASE_MAC:
                        label_mac_status.Text = "MAC успешно стерт";
                        label_mac_status.ForeColor = Color.Green;
                        break;
                }

                console_operation = ENUM_CONSOLE_CODES.OPERATION_NONE;
            }
            else if ( data.Contains("ERROR") )
            {

                switch (console_operation)
                {
                    case ENUM_CONSOLE_CODES.TEST_EEPROM:
                        label_eeprom_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_eeprom_test_status.ForeColor = Color.Red;
                        break;

                    case ENUM_CONSOLE_CODES.TEST_FLASH:
                        label_flash_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_flash_test_status.ForeColor = Color.Red;
                        break;

                    case ENUM_CONSOLE_CODES.TEST_RS485:
                        label_rs_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_rs_test_status.ForeColor = Color.Red;
                        serialPortRS485.Close();
                        RS485PortTimer.Stop();
                        break;
                    case ENUM_CONSOLE_CODES.TEST_ETHERNET:
                        label_ethernet_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_ethernet_test_status.ForeColor = Color.Red;
                        break;
                    case ENUM_CONSOLE_CODES.TEST_OLED:
                        label_olerd_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_olerd_test_status.ForeColor = Color.Red;
                        break;
                    case ENUM_CONSOLE_CODES.TEST_7SEG:
                        label_seg7_test_status.Text = "ТЕСТ ПРОВАЛЕН";
                        label_seg7_test_status.ForeColor = Color.Red;
                        break;

                    case ENUM_CONSOLE_CODES.WRITE_SN:
                        label_sn_status.Text = "Запись ЗН  провалена!!!";
                        label_sn_status.ForeColor = Color.Red;
                        break;
                    case ENUM_CONSOLE_CODES.READ_SN:
                        label_sn_status.Text = "Чтение ЗН  провалено!!!";
                        label_sn_status.ForeColor = Color.Red;
                        break;
                    case ENUM_CONSOLE_CODES.ERASE_SN:
                        label_sn_status.Text = "Стирание ЗН  провалено!!!";
                        label_sn_status.ForeColor = Color.Red;
                        break;
                    case ENUM_CONSOLE_CODES.WRITE_MAC:
                        break;
                    case ENUM_CONSOLE_CODES.READ_MAC:
                        break;
                    case ENUM_CONSOLE_CODES.ERASE_MAC:
                        break;
                }

                console_operation = ENUM_CONSOLE_CODES.OPERATION_NONE;
            }
        }

        private void send_console_data(string data)
        {

            if (console_port_is_open)
            {
                serialPortConsole.WriteLine(data);
                view_console_data(">>", data);
            }
            else
            {
                MessageBox.Show(" Порт консоли закрыт!!!!");
            }
        }


        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                if ( console_port_is_open ==  false )
                {
                    serialPortConsole.PortName = ConsolePortNameTextBox.Text;
                    serialPortConsole.Open();
                    serialPortConsole.DiscardInBuffer();
                    serialPortConsole.DiscardOutBuffer();
                    ConsolePortTimer.Start();

                    console_port_is_open = true;
                    button1.Text = "Отключиться";
                    ConsoleSendButton.Enabled = true;
                }
                else
                {
                    serialPortConsole.Close();
                    ConsolePortTimer.Stop();

                    console_port_is_open = false;
                    button1.Text = "Подключиться";
                    ConsoleSendButton.Enabled = false;
                }
            }
            catch 
            {
                MessageBox.Show("Проблемы с открытием порта");
            }
        }

        private void ConsolePortTimer_Tick(object sender, EventArgs e)
        {
            string str = serialPortConsole.ReadExisting();

            if (str != null && str.Length != 0)
            {
                int new_pos = 0;
                int prev_pos = 0;

                while (true)
                {
                    new_pos = str.IndexOf('\n', prev_pos );

                    if ((new_pos == -1) || new_pos > str.Length)
                        return;

                    string substr = str.Substring((prev_pos), (new_pos - prev_pos - 1));

                    view_console_data("<<", substr);

                    prev_pos = new_pos + 1;

                    parse_console_data(substr);
                }
            }
        }

        private void ConsoleSendButton_Click(object sender, EventArgs e)
        {
            send_console_data(ConsoleSendDataTextBox.Text);
        }

        private void buttonEEPROM_Click(object sender, EventArgs e)
        {
            label_eeprom_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_eeprom_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_eeprom_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_EEPROM;

            send_console_data("test eeprom");

        }

        private void label3_Click(object sender, EventArgs e)
        {

        }

        private void buttonFLASH_Click(object sender, EventArgs e)
        {
            label_flash_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_flash_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_flash_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_FLASH;

            send_console_data("test flash");
        }

        private void label4_Click(object sender, EventArgs e)
        {

        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void buttonRS_Click(object sender, EventArgs e)
        {
            serialPortRS485.PortName = RS485PortTextBox.Text;
            serialPortRS485.Open();
            serialPortRS485.DiscardInBuffer();
            serialPortRS485.DiscardOutBuffer();


            label_rs_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_rs_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_rs_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_RS485;
            send_console_data("test rs");

            RS485PortTimer.Start();

        }

        // ------------------------------------------------------------------------
        // Event for response data
        // ------------------------------------------------------------------------
        private void MBmaster_OnResponseData(ushort ID, byte unit, byte function, byte[] values)
        {
            // ------------------------------------------------------------------
            // Seperate calling threads
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new Master.ResponseData(MBmaster_OnResponseData), new object[] { ID, unit, function, values });
                return;
            }

            // ------------------------------------------------------------------------
            // Identify requested data
            switch (ID)
            {
                case 1:
 /*
                    grpData.Text = "Read coils";
                    data = values;
                    ShowAs(null, null);
*/

                    break;
                case 2:
 /*
                    grpData.Text = "Read discrete inputs";
                    data = values;
                    ShowAs(null, null);
*/
                    break;
                case 3:

                    byte[] data = values;
                    ushort reg100 = ( ushort ) (data[ 1 ] * 256 + data[ 0 ] );

                    if ( reg100 ==  0 )
                    {
                        ushort ID7 = 7;
                        byte unit0 = 0;
                        ushort StartAddress = 256;

                        byte[] data2 = {  0x55, 0x55 };

                        MBmaster.WriteSingleRegister(ID7, unit0, StartAddress, data2);
                    }

                    break;
                case 4:
                    /*
                                       grpData.Text = "Read input register";
                                       data = values;
                                       ShowAs(null, null);
                   */
                    break;
                case 5:
//                    grpData.Text = "Write single coil";

                    break;
                case 6:
  //                  grpData.Text = "Write multiple coils";
                    break;
                case 7:
 //                   grpData.Text = "Write single register";


                    break;
                case 8:
 //                   grpData.Text = "Write multiple register";
                    break;
            }


        }

        // ------------------------------------------------------------------------
        // Modbus TCP slave exception
        // ------------------------------------------------------------------------
        private void MBmaster_OnException(ushort id, byte unit, byte function, byte exception)
        {
            string exc = "Modbus says error: ";
            switch (exception)
            {
                case Master.excIllegalFunction: exc += "Illegal function!"; break;
                case Master.excIllegalDataAdr: exc += "Illegal data adress!"; break;
                case Master.excIllegalDataVal: exc += "Illegal data value!"; break;
                case Master.excSlaveDeviceFailure: exc += "Slave device failure!"; break;
                case Master.excAck: exc += "Acknoledge!"; break;
                case Master.excGatePathUnavailable: exc += "Gateway path unavailbale!"; break;
                case Master.excExceptionTimeout: exc += "Slave timed out!"; break;
                case Master.excExceptionConnectionLost: exc += "Connection is lost!"; break;
                case Master.excExceptionNotConnected: exc += "Not connected!"; break;
            }

            MessageBox.Show(exc, "Modbus slave exception");
        }


        private void buttonEhernet_Click(object sender, EventArgs e)
        {
            label_ethernet_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_ethernet_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_ethernet_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_ETHERNET;
            send_console_data("test ethernet");

            try
            {
                // Create new modbus master and add event functions
                MBmaster = new Master(txtIP.Text, 502, true);
                MBmaster.OnResponseData += new ModbusTCP.Master.ResponseData(MBmaster_OnResponseData);
                MBmaster.OnException += new ModbusTCP.Master.ExceptionData(MBmaster_OnException);

                ushort ID = 3;
                byte unit = 0;
                ushort StartAddress = 256;
                UInt16 Length = 1;

                MBmaster.ReadHoldingRegister(ID, unit, StartAddress, Length);

            }
            catch (SystemException error)
            {
                MessageBox.Show(error.Message);
            }



        }

        private void label7_Click(object sender, EventArgs e)
        {

        }

        private void RS485PortTimer_Tick(object sender, EventArgs e)
        {
            int rx_len = serialPortRS485.BytesToRead;

            if( rx_len > 0 ) 
            {
                for( int i = 0; i < rx_len; i++ )
                {
                    rs485_buffer[rs485_pos++] = (byte)serialPortRS485.ReadByte(); ;

                }
            }
            else if( 0 != rs485_pos )
            {
                serialPortRS485.Write(rs485_buffer, 0, rs485_pos);

                rs485_pos = 0;
            }
        }

        private void buttonOLED_Click(object sender, EventArgs e)
        {
            label_olerd_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_olerd_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_olerd_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_OLED;
            send_console_data("test oled");
        }

        private void tabPage1_Click(object sender, EventArgs e)
        {

        }

        private void button7SEG_Click(object sender, EventArgs e)
        {
            label_seg7_test_status.Text = "ТЕСТ НЕ ПРОЙДЕН";
            label_seg7_test_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_seg7_test_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.TEST_7SEG;
            send_console_data("test seg7");

        }

        private void WriteSNbutton_Click(object sender, EventArgs e)
        {
            label_sn_status.Text = "Статус неизвестен";
            label_sn_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_sn_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.WRITE_SN;

            string cmd = "write sn " + SNtextBox.Text;
            send_console_data( cmd );
        }

        private void ReadSNbutton_Click(object sender, EventArgs e)
        {
            label_sn_status.Text = "Статус неизвестен";
            label_sn_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_sn_status.Refresh();
            SNtextBox.Text = "";
            SNtextBox.Refresh();

            console_operation = ENUM_CONSOLE_CODES.READ_SN;

            send_console_data("read sn");
        }

        private void EraseSNbutton_Click(object sender, EventArgs e)
        {
            label_sn_status.Text = "Статус неизвестен";
            label_sn_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_sn_status.Refresh();
            SNtextBox.Text = "";
            SNtextBox.Refresh();

            console_operation = ENUM_CONSOLE_CODES.ERASE_SN;

            send_console_data("erase sn");
        }

        private void textBox1_TextChanged_1(object sender, EventArgs e)
        {

        }

        private void WriteMACbutton_Click(object sender, EventArgs e)
        {
            label_mac_status.Text = "Статус неизвестен";
            label_mac_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_mac_status.Refresh();

            console_operation = ENUM_CONSOLE_CODES.WRITE_MAC;

            string cmd = "write mac " + MACtextBox.Text;
            send_console_data(cmd);

        }

        private void ReadMACbutton_Click(object sender, EventArgs e)
        {
            label_mac_status.Text = "Статус неизвестен";
            label_mac_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_mac_status.Refresh();
            MACtextBox.Text = "";
            MACtextBox.Refresh();

            console_operation = ENUM_CONSOLE_CODES.READ_MAC;

            send_console_data("read mac");


        }

        private void EraseMACbutton_Click(object sender, EventArgs e)
        {
            label_mac_status.Text = "Статус неизвестен";
            label_mac_status.ForeColor = System.Drawing.SystemColors.ControlText;
            label_mac_status.Refresh();
            MACtextBox.Text = "";
            MACtextBox.Refresh();

            console_operation = ENUM_CONSOLE_CODES.ERASE_MAC;

            send_console_data("erase mac");
        }
    }
}
